/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.util.conditions.ConditionType;
import dev.toma.gunsrpg.resource.util.conditions.Conditions;
import dev.toma.gunsrpg.resource.util.conditions.IConditionSerializer;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class ResourceUtils {
    public static List<IRecipeCondition> getConditionsFromJson(JsonArray array) throws JsonSyntaxException {
        ArrayList<IRecipeCondition> list = new ArrayList<IRecipeCondition>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            Object condition = ResourceUtils.resolveCondition(element);
            list.add((IRecipeCondition)condition);
        }
        return list;
    }

    public static <C extends IRecipeCondition> C resolveCondition(JsonElement element) throws JsonSyntaxException {
        JsonObject obj = JsonHelper.asJsonObject(element);
        String id = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
        ResourceLocation location = new ResourceLocation(id);
        ConditionType type = Conditions.find(location);
        if (type == null) {
            throw new JsonSyntaxException("Unknown recipe condition type: " + id);
        }
        JsonObject predicate = JSONUtils.func_152754_s((JsonObject)obj, (String)"predicate");
        IConditionSerializer serializer = type.getSerializer();
        return serializer.deserialize(predicate);
    }
}

